/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.gamecontext;

import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.Map;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;

@Singleton
public class GameContextRegister {
    private Map<String, GameContextAware> registered = new HashMap<String, GameContextAware>();
    private GameContext currentContext;

    public void register(GameContextAware contextAwareInstance) {
        String className = contextAwareInstance.getClass().getName();
        if (this.registered.containsKey(className)) {
            throw new RuntimeException("Duplicate class registered in " + this.getClass().getName() + ": " + className);
        }
        this.registered.put(className, contextAwareInstance);
        if (this.currentContext != null) {
            contextAwareInstance.onContextChange(this.currentContext);
        }
    }

    public void setNewContext(GameContext newContext) {
        this.currentContext = newContext;
        for (GameContextAware contextAware : this.registered.values()) {
            contextAware.onContextChange(this.currentContext);
        }
    }

    public boolean isRegistered(Class<? extends GameContextAware> classType) {
        return this.registered.containsKey(classType.getName());
    }
}

